using System;
using System.Linq;

public class ShipAndApples
{
    //     public struct Point
    {
        public long X, Y;
        public double Distance(Point other)
        {
            return Math.Sqrt(Math.Pow(X - other.X, 2) + Math.Pow(Y - other.Y, 2));
        }
    }

    // Funkcija za izracunavanje udaljenosti tacke P od segmenta linije AB
    public static double DistancePointToSegment(Point P, Point A, Point B)
    {
        long AB_X = B.X - A.X;
        long AB_Y = B.Y - A.Y;

        // Ako je segment nulte dužine, vrati udaljenost do tacke A
        if (AB_X == 0 && AB_Y == 0) return P.Distance(A);

        long AP_X = P.X - A.X;
        long AP_Y = P.Y - A.Y;

        // Projekcija t = (AP . AB) / |AB|^2
        double dotProduct = AP_X * AB_X + AP_Y * AB_Y;
        double lenSq = AB_X * AB_X + AB_Y * AB_Y;
        double t = dotProduct / lenSq;

        if (t < 0) return P.Distance(A); // Projekcija van segmenta, najbliža tacka je A
        if (t > 1) return P.Distance(B); // Projekcija van segmenta, najbliža tacka je B

        // Najbliža tacka Q je na segmentu
        double Qx = A.X + t * AB_X;
        double Qy = A.Y + t * AB_Y;

        return Math.Sqrt(Math.Pow(P.X - Qx, 2) + Math.Pow(P.Y - Qy, 2));
    }

    public static void Solve()
    {
        try
        {
            // Ucitavanje ulaza
            int N = int.Parse(Console.ReadLine());
            long[] X_dist = Console.ReadLine().Split(' ').Select(long.Parse).ToArray();
            long[] H_height = Console.ReadLine().Split(' ').Select(long.Parse).ToArray();
            
            // Provera konzistentnosti ulaza
            if (X_dist.Length != N || H_height.Length != N)
            {
                // Za primer ulaza iz teksta
                Console.WriteLine("Greška: Ulazni podaci nisu konzistentni sa N.");
                return;
            }

            // Izracunavanje koordinata jabuka
            Point[] apples = new Point[N];
            long current_X = 0;
            for (int i = 0; i < N; i++)
            {
                current_X += X_dist[i];
                apples[i] = new Point { X = current_X, Y = H_height[i] };
            }

            Point ship = new Point { X = 0, Y = 0 };

            // Glavna petlja: za svaku jabuku
            for (int i = 0; i < N; i++)
            {
                Point currentApple = apples[i];
                
                // 1. Udaljenost do Broda (0,0)
                double min_dist = currentApple.Distance(ship);

                // 2. Udaljenost do ostalih Kanala (segmenata)
                // Kanal K_j je segment izmedu apples[j] i apples[j+1]
                for (int j = 0; j < N - 1; j++)
                {
                    // Udaljenost se racuna samo do segmenata koji NE sadrže trenutnu jabuku.
                    // Jabuka je krajnja tacka segmenta K_j ako je i == j ili i == j+1.
                    if (i == j || i == j + 1) continue; 

                    Point A = apples[j];
                    Point B = apples[j + 1];

                    double dist_to_canal = DistancePointToSegment(currentApple, A, B);
                    min_dist = Math.Min(min_dist, dist_to_canal);
                }

                // Ispis rezultata: Zaokružiti na najbliži ceo broj, kako je u primeru.
                Console.WriteLine(Math.Round(min_dist));
            }
        }
        catch (Exception ex)
        {
            // U slucaju greške u formatu ulaza
            Console.WriteLine(-1);
            // Console.WriteLine($"An error occurred: {ex.Message}");
        }
    }
}